#ifndef MAP_H_INCLUDED
#define MAP_H_INCLUDED

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#define TILE_TAILLE 32
#define FX_FICHIER "fx.png"
#define COUT_SOL 1
#define COUT_FORET 2
#define COUT_EAU 0

#define MAPS_DIR "maps/"

// Enumration des types de terrain
enum tile_type {
SOL,        // Type Sol -> Franchissable
OBSTACLE,   // Type Obstacle -> Ne peut pas tre travers
CAMP,       // Type Obstacle -> Ne peut pas tre travers
MORTEL      // Type Mortel -> Tue le personnage qui s'y trouve
};

// Enumration des tats des cases
enum case_etat {
INCONNU,    // Non explor
MASQUE,     // Masqu par le brouillard de guerre
VISIBLE     // Compltement visible
};

// Structure d'une tile
typedef struct s_tile{
    enum tile_type type;    // Type de terrain
    long frame;             // Frame de l'animation en cours
    long cout_pts;          // Cot en Points de mouvement
    SDL_Color couleur;      // Couleur de la tile dans la minimap
} t_tile;

// Structure d'une case de la map
typedef struct s_map_case {
    long tile;              // Numro de la tile
    enum case_etat etat;    // Etat de la Case
} t_map_case;

// Structure d'un Tileset
typedef struct s_tileset {
    char* fichier;      // Nom du fichier du tileset
    SDL_Surface* image; // Surface du tileset
    long largeur;       // Nombre de tile en largeur
    long hauteur;       // Nombre de tile en hauteur
} t_tileset;

// Structure de la Map
typedef struct s_map {
    /// Donnes de la map
    char* fichier;      // Nom du fichier de la map
    long largeur;       // Largeur de la map
    long hauteur;       // Hauteur de la map
    t_map_case** cases; // Tableau 2D des cases de la map
    /// Apparence de la map
    t_tileset tileset;  // Tileset du dcor de la map
    t_tile* tile;       // Liste des tiles de la map
    t_tileset fx;       // Tileset des effets
} t_map;

#include "interface.h"

/// Fonctions d'initialisation / libration
void nouvelle_map(t_map *map); // Cre une nouvelle map vide
void charger_map(t_map *map); // Charge une map a partir d'un fichier .map
long sauvegarder_map(t_map *map); // Sauvegarde une map dans un fichier .map
void liberer_map(t_map * map); // Supprime les donnes de l'interface

/// Fonctions d'affichage / Rafraichissement
void afficher_map(t_map* map,t_interface* interface); // Blitte la map sur l'cran
void actualiser_minimap(t_map* map,t_interface* interface); // Actualise la minimap  partir des donnes de la map

/// Fonction de conversion de donnes
void conversion_tile_tileset(long tile, long largeur,long hauteur, SDL_Rect *crop); // Recupre les coordonnes de rognage d'un tileset  partir du numro de tile
void obtenir_case(t_interface* interface); // Obtient les coordonnes de la case situe sous le pointeur de la souris
long rand_coef(long coef);
void generer_map(t_map* map, long BORDURE, long RAYON_MAX, long EAU_COEF, long FORET_COEF, long DECO_COEF);
#endif // MAP_H_INCLUDED
